/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.status;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.StatusMonitorConfigBean;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StatusMonitorManager {
    private static final String TRACEMASK_T = "XBUISTST";
    private static final String TRACEMASK_F = "XBUISTSF";
    private static final String TRACEMASK_D = "XBUISTSD";
    private static StatusMonitorManager statusManager;
    private static Object lock;
    private List statusMonitors;

    private StatusMonitorManager(List configBeans) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<> StatusMonitorManager(" + configBeans + ")");
        this.statusMonitors = new ArrayList(configBeans.size());
        StatusMonitorConfigBean bean = null;
        StatusMonitorInterface monitor = null;
        Iterator i = configBeans.iterator();
        while (i.hasNext()) {
            bean = (StatusMonitorConfigBean)i.next();
            try {
                monitor = (StatusMonitorInterface)Class.forName(bean.getClassName()).newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
            monitor.init(bean.getKey(), bean.getParameters(), bean.getUIInfo());
            this.statusMonitors.add(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(List configBeans) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<--> StatusMonitorManager.init(" + configBeans + ")");
        Object object = lock;
        synchronized (object) {
            if (statusManager == null) {
                statusManager = new StatusMonitorManager(configBeans);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusMonitorManager getStatusMonitorManager() {
        Object object = lock;
        synchronized (object) {
            return statusManager;
        }
    }

    public List getStatusMonitorBeans(UISession session) {
        ArrayList<StatusMonitorBean> usersMonitors = new ArrayList<StatusMonitorBean>(this.statusMonitors.size());
        StatusMonitorBean bean = null;
        Iterator i = this.statusMonitors.iterator();
        while (i.hasNext()) {
            bean = ((StatusMonitorInterface)i.next()).getStatusMonitorBean(session);
            if (bean == null) continue;
            usersMonitors.add(bean);
        }
        return usersMonitors;
    }

    static {
        lock = new Object();
    }
}

